﻿using System;

using Xamarin.Forms;

namespace Peak.Controls
{
    public class RoundedButton : Button
    {

        public new static readonly BindableProperty PaddingProperty = BindableProperty.Create(nameof(Padding), typeof(Thickness), typeof(RoundedButton), new Thickness(0,0,0,0));
        private bool _measured = false;
        private bool _self = false;
       
        public RoundedButton()
        {
            CornerRadius = 6;
            BorderWidth = 2;
            HeightRequest = 40;
        }

        public new Thickness Padding
        {
            get { return (Thickness)GetValue(PaddingProperty); }
            set { SetValue(PaddingProperty, value); }
        }

        protected override SizeRequest OnMeasure(double widthConstraint, double heightConstraint)
        {
            if (!_self)
            {
                _measured = true;
            }

            return base.OnMeasure(widthConstraint, heightConstraint);
        }

        protected override void OnSizeAllocated(double width, double height)
        {
            base.OnSizeAllocated(width, height);

            if (_measured)
            {
                _measured = false;
                _self = true;

                WidthRequest = width + Padding.Left + Padding.Right;
                HeightRequest = height + Padding.Top + Padding.Bottom;
            }
            else
            {
                _self = false;
            }
        }
    }
}

